/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CIcon.h,v 1.4 1999/12/05 02:23:34 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CIcon_h	// [
#define Included_CIcon_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CIcon

class CIcon
{
	NOT_COPYABLE(CIcon)

public:
	enum
	{
		kSmallIconWidth		= 16, 
		kSmallIconHeight	= 16
	};

public:
	CIcon();
	CIcon(HICON icon, PGPBoolean weOwn = FALSE);
	CIcon(HINSTANCE instance, const char *name, PGPBoolean shared = FALSE);
	~CIcon();

	CIcon&	operator=(HICON icon);

	operator HICON() const {return mIcon;}
	HICON	Get() const {return mIcon;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	PGPBoolean	DrawIcon(HDC dc, PGPInt32 x, PGPInt32 y, 
		PGPInt32 width = 0, PGPInt32 height = 0, PGPUInt32 animIndex = 0, 
		HBRUSH flickerFreeBrush = 0, PGPUInt32 flags = DI_NORMAL) const;

	void	Load(HINSTANCE instance, const char *name, 
		PGPBoolean shared = FALSE);
	void	Attach(HICON icon, PGPBoolean weOwn = FALSE);
	void	Clear();

private:
	PGPBoolean	mWeCreated;
	HICON		mIcon;
};


// Class CIcon member functions

inline 
CIcon::CIcon() : mWeCreated(FALSE), mIcon(NULL)
{
}

inline 
CIcon::CIcon(HICON icon, PGPBoolean weOwn) : mWeCreated(FALSE), mIcon(NULL)
{
	Attach(icon, weOwn);
}

inline 
CIcon::CIcon(HINSTANCE instance, const char *name, PGPBoolean shared) : 
	mWeCreated(FALSE), mIcon(NULL)
{
	Load(instance, name, shared);
}

inline 
CIcon::~CIcon()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
CIcon& 
CIcon::operator=(HICON icon)
{
	Attach(icon);
	return *this;
}

inline 
PGPBoolean 
CIcon::IsAttached() const
{
	return IsntNull(mIcon);
}

inline 
PGPBoolean 
CIcon::DrawIcon(
	HDC			dc, 
	PGPInt32	x, 
	PGPInt32	y, 
	PGPInt32	width, 
	PGPInt32	height, 
	PGPUInt32	animIndex, 
	HBRUSH		flickerFreeBrush, 
	PGPUInt32	flags) const
{
	return ::DrawIconEx(dc, x, y, mIcon, width, height, animIndex, 
		flickerFreeBrush, flags);
}

_PGP_END

#endif	// ] Included_CIcon_h
